/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.wood;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockLeavesTFC
extends BlockLeaves {
    private static final Map<Tree, BlockLeavesTFC> MAP = new HashMap<Tree, BlockLeavesTFC>();
    public final Tree wood;

    public static BlockLeavesTFC get(Tree wood) {
        return MAP.get((Object)wood);
    }

    public BlockLeavesTFC(Tree wood) {
        this.wood = wood;
        if (MAP.put(wood, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false)));
        this.field_185686_c = true;
        OreDictionaryHelper.register((Block)this, "tree", "leaves");
        OreDictionaryHelper.register((Block)this, "tree", "leaves", wood.getRegistryName().func_110623_a());
        Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
        this.func_149675_a(true);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_176237_a) != false ? 1 : 0;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, @Nullable Block blockIn, @Nullable BlockPos fromPos) {
        world.func_175684_a(pos, (Block)this, 0);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn instanceof EntityPlayer) || !((EntityPlayer)entityIn).func_184812_l_()) {
            entityIn.func_180430_e(entityIn.field_70143_R - 6.0f, 1.0f);
            entityIn.field_70143_R = 0.0f;
            entityIn.field_70159_w *= ConfigTFC.General.MISC.leafMovementModifier;
            if (entityIn.field_70181_x < 0.0) {
                entityIn.field_70181_x *= ConfigTFC.General.MISC.leafMovementModifier;
            }
            entityIn.field_70179_y *= ConfigTFC.General.MISC.leafMovementModifier;
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176237_a});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.doLeafDecay(worldIn, pos, state);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ConfigTFC.General.TREE.enableSaplings ? Item.func_150898_a((Block)BlockSaplingTFC.get(this.wood)) : Items.field_190931_a;
    }

    protected int func_176232_d(IBlockState state) {
        return this.wood == Tree.SEQUOIA ? 0 : 25;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        this.field_185686_c = Minecraft.func_71410_x().field_71474_y.field_74347_j;
        return super.func_180664_k();
    }

    @Nonnull
    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int chance = this.func_176232_d(state);
        if (chance > 0) {
            ItemStack drop;
            if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                chance = 10;
            }
            if (RANDOM.nextInt(chance) == 0 && !(drop = new ItemStack(this.func_180660_a(state, RANDOM, fortune), 1, this.func_180651_a(state))).func_190926_b()) {
                drops.add((Object)drop);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        this.field_185686_c = Minecraft.func_71410_x().field_71474_y.field_74347_j;
        return true;
    }

    @Nonnull
    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack((Block)this));
    }

    private void doLeafDecay(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K || !((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            return;
        }
        HashSet<Object> paths = new HashSet<Object>();
        HashSet<BlockPos> evaluated = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos(pos);
        paths.add(pos);
        for (int i = 0; i < this.wood.getMaxDecayDistance(); ++i) {
            ArrayList<BlockPos> pathsToAdd = new ArrayList<BlockPos>();
            for (BlockPos blockPos : paths) {
                for (EnumFacing face : EnumFacing.values()) {
                    pos1.func_189533_g((Vec3i)blockPos).func_189536_c(face);
                    if (evaluated.contains(pos1) || !world.func_175667_e((BlockPos)pos1)) continue;
                    IBlockState state1 = world.func_180495_p((BlockPos)pos1);
                    if (state1.func_177230_c() == BlockLogTFC.get(this.wood)) {
                        return;
                    }
                    if (state1.func_177230_c() != this) continue;
                    pathsToAdd.add(pos1.func_185334_h());
                }
                evaluated.add(blockPos);
            }
            paths.addAll(pathsToAdd);
            paths.removeAll(evaluated);
        }
        world.func_175698_g(pos);
        int particleScale = 10;
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        block8: for (int i = 1; i < Constants.RNG.nextInt(4); ++i) {
            switch (Constants.RNG.nextInt(4)) {
                case 1: {
                    TFCParticles.LEAF1.sendToAllNear(world, x + (double)(Constants.RNG.nextFloat() / (float)particleScale), y - (double)(Constants.RNG.nextFloat() / (float)particleScale), z + (double)(Constants.RNG.nextFloat() / (float)particleScale), ((double)Constants.RNG.nextFloat() - 0.5) / (double)particleScale, -0.15 + (double)(Constants.RNG.nextFloat() / (float)particleScale), ((double)Constants.RNG.nextFloat() - 0.5) / (double)particleScale, 90);
                    continue block8;
                }
                case 2: {
                    TFCParticles.LEAF2.sendToAllNear(world, x + (double)(Constants.RNG.nextFloat() / (float)particleScale), y - (double)(Constants.RNG.nextFloat() / (float)particleScale), z + (double)(Constants.RNG.nextFloat() / (float)particleScale), ((double)Constants.RNG.nextFloat() - 0.5) / (double)particleScale, -0.15 + (double)(Constants.RNG.nextFloat() / (float)particleScale), ((double)Constants.RNG.nextFloat() - 0.5) / (double)particleScale, 70);
                    continue block8;
                }
                case 3: {
                    TFCParticles.LEAF3.sendToAllNear(world, x + (double)(Constants.RNG.nextFloat() / (float)particleScale), y - (double)(Constants.RNG.nextFloat() / (float)particleScale), z + (double)(Constants.RNG.nextFloat() / (float)particleScale), ((double)Constants.RNG.nextFloat() - 0.5) / (double)particleScale, -0.15 + (double)(Constants.RNG.nextFloat() / (float)particleScale), ((double)Constants.RNG.nextFloat() - 0.5) / (double)particleScale, 80);
                }
            }
        }
    }
}

